/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.skills.transaction;

import dev.toma.gunsrpg.api.common.ITransaction;
import dev.toma.gunsrpg.api.common.ITransactionType;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.skills.transaction.SkillPointTransaction;
import dev.toma.gunsrpg.common.skills.transaction.WeaponPointTransaction;

public final class TransactionTypes {
    public static final ITransactionType<SkillType<?>> SKILLPOINT_TRANSACTION = TransactionTypes.create(SkillPointTransaction::create);
    public static final ITransactionType<WeaponPointTransaction.IWeaponData> WEAPON_POINT_TRANSACTION = TransactionTypes.create((data, total) -> new WeaponPointTransaction((WeaponPointTransaction.IWeaponData)data));

    public static <T> ITransactionType<T> create(ITransactionFactory<T> factory) {
        return new SimpleTransactionType(factory);
    }

    public static <R> ITransactionType<R> cast(ITransactionType<?> type) {
        return type;
    }

    public static interface ITransactionFactory<T> {
        public ITransaction<T> createTransaction(T var1, int var2);
    }

    private static class SimpleTransactionType<T>
    implements ITransactionType<T> {
        private final ITransactionFactory<T> factory;

        private SimpleTransactionType(ITransactionFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public ITransaction<T> newTransaction(T data, int total) {
            return this.factory.createTransaction(data, total);
        }
    }
}

